#version 330
#extension GL_EXT_gpu_shader4 : enable
// Experiment 1001Mod01.fsh  by  kibitz9

//https://www.shadertoy.com/view/slsXR4
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//***************************************************************//
// More Fractal Surface Experiments by CMiller (kibitz9)
// I am experimenting with using fractals for surface detail (greebles). 
// This one I think hides the underlying mandelbox fractal rather well.
//***************************************************************// 

const float GLOBAL_EPSILON = .0005;
const vec2 GLOBAL_PN = vec2(1,-1);
const vec3 GLOBAL_PN_XYY=GLOBAL_PN.xyy;
const vec3 GLOBAL_PN_YYX=GLOBAL_PN.yyx;
const vec3 GLOBAL_PN_YXY=GLOBAL_PN.yxy;
const vec3 GLOBAL_PN_XXX=GLOBAL_PN.xxx;

const vec3 GLOBAL_PN_XYY_EPS=GLOBAL_PN_XYY*GLOBAL_EPSILON;
const vec3 GLOBAL_PN_YYX_EPS=GLOBAL_PN_YYX*GLOBAL_EPSILON;
const vec3 GLOBAL_PN_YXY_EPS=GLOBAL_PN_YXY*GLOBAL_EPSILON;
const vec3 GLOBAL_PN_XXX_EPS=GLOBAL_PN_XXX*GLOBAL_EPSILON;
const float MAX_DIST = 10.0;




float map7(vec3 p){

	float scale1=3.0;
	vec3 sp1=p/scale1;
	float rp1=4.000400010000001;
	float r1=2.0;
	float d1;
	if (length(sp1)>rp1){
		d1=length(sp1)-r1;
	}
	else{
		float sectorSize1=0.31415926536;
		float sectorNumber1=round(atan(sp1.y,sp1.x)/sectorSize1);
		float angleOffset1=-sectorNumber1*sectorSize1;
		float cos1=cos(angleOffset1);
		float sin1=sin(angleOffset1);
		vec3 q1=vec3(
			sp1.x*cos1-sp1.y*sin1,
			sp1.y*cos1+sp1.x*sin1,
			sp1.z
		);
		//float sectorSize2=0.31415926536;
		float sectorNumber2=round(atan(q1.x,q1.z)/sectorSize1);
		float angleOffset2=-sectorNumber2*sectorSize1;
		float cos2=cos(angleOffset2);
		float sin2=sin(angleOffset2);
		vec3 q2=vec3(
			q1.x*cos2+q1.z*sin2,
		q1.y,
			q1.z*cos2-q1.x*sin2
		);
		//float sectorSize3=0.31415926536;
		float sectorNumber3=round(atan(q2.y,q2.x)/sectorSize1);
		float angleOffset3=-sectorNumber3*sectorSize1;
		float cos3=cos(angleOffset3);
		float sin3=sin(angleOffset3);
		vec3 q3=vec3(
			q2.x*cos3-q2.y*sin3,
			q2.y*cos3+q2.x*sin3,
			q2.z
		);
		float cosTheta1=0.70710677;
		float sinTheta1=0.70710677;
		vec3 rot1=vec3(q3.x,q3.y*cosTheta1+q3.z*sinTheta1,q3.z*cosTheta1+q3.y*-sinTheta1);
		float scale2=0.75;
		vec3 sp2=rot1/scale2;
		vec4 q4=vec4(sp2,1.0);
		vec4 c1=vec4(sp2,1.0);
		float s1=-2.5;//+sin(iTime/7.)*2.;
		float r2=0.5+sin(iTime/3.)*.5;
		int itr1=10;
		float f1=1.0;
		for (int a1=0;a1<itr1;a1++){
			q4.xyz=f1*(clamp(q4.xyz,-1.0,1.0)*2.0-q4.xyz);
			q4 *=s1/clamp(dot(q4.xyz,q4.xyz),r2,1.0);
			q4 +=c1;
		}
		d1=(length(q4.xyz)/abs(q4.w))*scale2;
	}
	//Sphere1
	float radius1 =1.97;
	float unionleft1=d1;
	float unionRight1=length(sp1)-radius1;
	return (min(unionleft1,unionRight1))*scale1;
}

float map(in vec3 q){

    float time = iTime/8.5;
    //return 1.0;
    vec3 p=q;

    float lookDown=.2;
    float cosld=cos(lookDown);
    float sinld=sin(lookDown);
    p=vec3(p.x,p.y*cosld+p.z*-sinld,p.z*cosld+p.y*sinld);
    p =vec3(
        p.x*cos(time)+p.z*-sin(time),
        p.y
        ,p.z*cos(time)+p.x*sin(time)
    );
    p=p+vec3(0.,-2.+sin(time*2.)*.125,0.);
    
    float ang2 = sin(iTime/4.)*.25;
    p = vec3(p.x*cos(ang2)-p.y*sin(ang2),p.y*cos(ang2)+p.x*sin(ang2),p.z);

    float m;
    float mb=0.;

    bool bound = false;
    //float outer = (length(vec3(p.x,p.y*5.,p.z))-1.90);
   // float t=.008;
    //if (outer>2.*t){

    //    m=outer-t;
    //}
    //else{
        m= map7(p*5.);
        m/=5.;
    //}
   
   
    //m=max(m,outer);

    //float inner=length(vec3(p.x,p.y*6.,p.z))-1.890;
    //float sub = length(p)-1.4;
    //sub = abs(sub)-.15;
    
    //inner = max(inner,-sub);
    
    //inner +=mb/10.;
    
  
    
    //m=min(m,inner);
    
   
    
    m/=4.;
    //float n=m;
 
    m=min(m,q.y-.1);
    m=min(m,-q.z+3.);
   
    
    return m;
 }
    
    
    
 
    


vec3 getSurfaceNormal( in vec3 p, float epsilon ) // for function f(p)
{
  
    return normalize(
        GLOBAL_PN_XYY*map(p+GLOBAL_PN_XYY_EPS) +
        GLOBAL_PN_YYX*map(p+GLOBAL_PN_YYX_EPS) +
        GLOBAL_PN_YXY*map(p+GLOBAL_PN_YXY_EPS) +
        GLOBAL_PN_XXX*map(p+GLOBAL_PN_XXX_EPS) 
    
    );
}


void rayMarch(
    in vec3 origin, 
    in vec3 ray, 
    in float epsilon,
    in float maxSteps,
   
    out vec3 marchPoint,
    out float marchPointDist,
    out float stepsTaken


){
    
  
    
    stepsTaken = 0.0;
    marchPoint=origin;
    float h = map(marchPoint);
    while (h>epsilon&&stepsTaken++<maxSteps&&h<MAX_DIST){
        marchPoint+=ray*h;       
        h=map(marchPoint);
    }   
    marchPointDist=h;
}

float softShadowBalanced(vec3 surface, vec3 light, float radius, float maxDist){
   
    
  
    vec3 surfaceToLight = light-surface;
    float distanceToLight=length(surfaceToLight);
    float maxDist2 = min(maxDist,distanceToLight);
    vec3 ray =normalize(surfaceToLight);
    float artifactCompensation = 1.0;
    float minDist = 0.2;//think about this.
    
    float travelled = minDist;
    float xx=1.0;
    while (travelled < maxDist2){
    
        float ratioTravelled=travelled/distanceToLight;
        
       
        float relativeRadius=ratioTravelled*radius;
        
        float dist=map(surface+ray*travelled);
         
        if (dist<-relativeRadius){
            return 0.0;
        }
        float relativeDiameter=relativeRadius*2.0;
        
        float dist2=dist+relativeRadius;
        xx = min(xx,dist2/relativeDiameter);
        
       
        float artifatCompensation2 = artifactCompensation*clamp(relativeRadius/dist,0.,1.);
        travelled +=max(abs(dist/artifactCompensation),minDist);
        
        
    }
       
   return xx;
    

    
}

vec3 power(vec3 vec, float power){
    return vec3(pow(vec.x,power),pow(vec.y,power),pow(vec.z,power));
}



void calcLight(
    in vec3 surfacePoint, 
    in float shineAtPosition,
    in vec3 lightPosition,
    in vec3 observationPosition,
    in vec3 lightColor,
    in float lightBrightness,
    in vec3 surfaceNormal,
    in float epsilon,
    in float lightRadius,
    out vec3 diffuse, 
    out vec3 specular){
    
 
     
    vec3 col0 = lightColor;
    
    
    vec3 surfaceToLight=lightPosition-surfacePoint;
    vec3 normalToLight=normalize(surfaceToLight);
    
    float oneOverDistToLightSquared = lightBrightness/dot(surfaceToLight,surfaceToLight);
    
    
    
    float dp = dot(normalToLight,surfaceNormal);
 
    dp=max(dp,0.0);

    
    diffuse=dp*lightColor*oneOverDistToLightSquared;
    
    
    vec3 rayToObs=normalize(observationPosition-surfacePoint);
    vec3 avg = normalize(normalToLight+rayToObs);
    float spec = dot(avg,surfaceNormal);
    spec = max(spec,0.0);
    
    spec = pow(spec,shineAtPosition);

    specular=lightColor*spec*oneOverDistToLightSquared;
    
    float shadowAdjust = 1.0;
    

    if (true){
        float s = softShadowBalanced(surfacePoint,lightPosition,lightRadius, 500.); 
        diffuse*=s*shadowAdjust;
        specular*=s*shadowAdjust;
    }
 
}

void main (void)
//void mainImage1( out vec4 gl_FragColor, in vec2 gl_FragCoord.xy )
{


    vec3 eye = vec3(0.0,0.0,-.5);
    vec3 lense = vec3(0.0,0.0,.5);
    float xxx = 0.;
    vec3 cameraPosition = vec3(0.,2.,-(5.+xxx)+sin(iTime/10.)*xxx);
    float specAmt = 0.0;

    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float epsilon1 = .002;
    
   
    vec3 objColor=vec3(1,1,1);
  
    vec2 ar = (gl_FragCoord.xy/iResolution.x)
        -vec2(.5,iResolution.y/(2.0*iResolution.x));
    vec3 lenseIntersection = vec3(ar,lense.z);
    
    vec3 ray = normalize(lenseIntersection-eye);
   
    
    float stepsTaken;
    vec3 finalPosition;
    float finalDistance;

    float maxSteps = 4000.0;
    
    rayMarch(eye+cameraPosition,ray,epsilon1,maxSteps,finalPosition,finalDistance,stepsTaken);
    
  
    
    float objectShine=14.;
    
    
    vec3 diffuse1;
    vec3 specular1;

    vec3 diffuse2;
    vec3 specular2;

    vec3 diffuse3;
    vec3 specular3;

    vec3 diffuse4;
    vec3 specular4;
    if (finalDistance<epsilon1){
    

        finalPosition = finalPosition+(ray*epsilon1*-2.0);
        vec3 normal = getSurfaceNormal(finalPosition,epsilon1);
        
       
        
        float lightBrightness = 1400.;
        float specMult = 2.0;
        
        calcLight(
            finalPosition,
            objectShine,
            vec3(30.0,40.0,-40.0),//lightposition
            eye+cameraPosition,//observation position
            vec3(.25,.25,1.),//light color
            lightBrightness*1.55,//light bright
       
            normal,
            epsilon1,
            1.,
            diffuse1,
            specular1
        );
        
        
         calcLight(
            finalPosition,
            objectShine,
            vec3(-30.0,40.0,-40.0),//lightposition
            eye+cameraPosition,//observation position
            vec3(1.7,.325,0.)*.5,//light color
            lightBrightness*1.5,//light bright
            normal,
            epsilon1,
            1.,
            diffuse2,
            specular2
        );
        
        
        
        calcLight(
            finalPosition,
            objectShine,
            vec3(0.0,30.0,-40.0),//lightposition
            eye+cameraPosition,//observation position
            vec3(.25,.9,.1)*.5,//light color
            lightBrightness*.75,//light bright
            normal,
            epsilon1,
            .5,
            diffuse3,
            specular3
        );
        
        /*
        calcLight(
            finalPosition,
            objectShine,
            vec3(130.0,30.0,-480.0),//lightposition
            eye+cameraPosition,//observation position
            vec3(1.,.9,.3)*.5,//light color
            lightBrightness*5.,//light bright
            normal,
            epsilon1,
            diffuse3,
            specular3
        );
        */
        
        
        /*
        calcLight(
            finalPosition,
            objectShine,
            vec3(0.0,10.0,-5.0),//lightposition
            eye+cameraPosition,//observation position
            vec3(1.,.8,.5)*.5,//light color
            lightBrightness/20000.,//light bright
            normal,
            epsilon1,
            diffuse4,
            specular4
        );
    */
    
    
        
    
        vec3 col1=objColor*max(diffuse1,0.0);
        col1+=specular1*specMult;
        
        vec3 col2=objColor*max(diffuse2,0.0);
        col2+=specular2*specMult;
        
        vec3 col3=objColor*max(diffuse3,0.0);
        col3+=specular3*specMult;
        
        //vec3 col4=objColor*max(diffuse4,0.0);
        //col4+=specular4*specMult;
        
        
      
       
        
        //vec3 colFinal = min(col1+col2,1.0);
        //vec3 colFinal = min(col1+col2+col3+col4,1.);
        vec3 colFinal = min(col1+col2+col3,1.);
        colFinal=power(colFinal,.9);
        
     
        
        colFinal = pow(colFinal,vec3(.75,.74,.73));
        
        gl_FragColor = vec4(colFinal,1.0);
        
    }
   
 else{
        gl_FragColor = vec4(.2,0,0,1.0);

    }
    

   
  
}
 /* 
void AntiAlias3( out vec4 gl_FragColor, in vec2 gl_FragCoord.xy, float aaLevel){
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    
    float subPixel = 1.0/aaLevel;
    vec4 result = vec4(0,0,0,1);
    for (float x=gl_FragCoord.x;x<gl_FragCoord.x+1.0;x+=subPixel){
        for (float y= gl_FragCoord.y;y<gl_FragCoord.y+1.0;y+=subPixel){
            vec4 temp;
            mainImage1(temp,vec2(x,y));
            result+=temp;
        }
    }
    
    //vec3 r = vec3(0);
    //vec3 x = vec3(1);
    //vec3 t = clamp(r,x,x);
    
    
    gl_FragColor = result/(aaLevel*aaLevel);
   
    
}


void main (void)
//void mainImage ( out vec4 fragColor, in vec2 fragCoord)
{

    if (false){
        AntiAlias3(gl_FragColor, gl_FragCoord.xy,2.);
    }
    else  


        vec4 result = vec4(0,0,0,1);
        mainImage(result,gl_FragCoord.xy);
        gl_FragColor=result;
    }

*/
